--Create the tables
USE [DBA_Monitoring]
GO

-- used to collect the first round of Index read counts
CREATE TABLE [dbo].[IndexOverviewReadsWithCounts_stage](
	[ServerName] [nvarchar](128) NULL,
	[Database] [nvarchar](128) NULL,
	[Object] [nvarchar](128) NULL,
	[execution_count] [bigint] NOT NULL,
	[total_logical_reads] [bigint] NOT NULL,
	[total_physical_reads] [bigint] NOT NULL
) ON [PRIMARY]

GO

--used to collect the first round of Index read counts and queries
CREATE TABLE [dbo].[IndexOverviewReadsWithQuery_stage](
	[ServerName] [nvarchar](128) NULL,
	[Database] [nvarchar](128) NULL,
	[Object] [nvarchar](128) NULL,
	[execution_count] [bigint] NOT NULL,
	[total_logical_reads] [bigint] NOT NULL,
	[total_physical_reads] [bigint] NOT NULL,
	[Statement] [nvarchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

--used as final index reads with counts where database name is updated to monitored database
CREATE TABLE [dbo].[IndexOverviewReadsWithCounts](
	[ServerName] [nvarchar](128) NULL,
	[Database] [nvarchar](128) NULL,
	[Object] [nvarchar](128) NULL,
	[execution_count] [bigint] NOT NULL,
	[total_logical_reads] [bigint] NOT NULL,
	[total_physical_reads] [bigint] NOT NULL
) ON [PRIMARY]
GO

----used as final index reads with statements where database name is updated to monitored database
CREATE TABLE [dbo].[IndexOverviewReadsWithQuery](
	[ServerName] [nvarchar](128) NULL,
	[Database] [nvarchar](128) NULL,
	[Object] [nvarchar](128) NULL,
	[execution_count] [bigint] NOT NULL,
	[total_logical_reads] [bigint] NOT NULL,
	[total_physical_reads] [bigint] NOT NULL,
	[Statement] [nvarchar](max) NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

--used to collect duplicate index
CREATE TABLE [dbo].[IndexOverview_DuplicateIndex](
	[ServerName] [nvarchar](128) NULL,
	[DBName] [varchar](100) NOT NULL,
	[TableName] [sysname] NOT NULL,
	[IndexName] [sysname] NULL,
	[OverLappingIndex] [sysname] NULL,
	[Col1] [nvarchar](128) NULL,
	[Col2] [nvarchar](128) NULL,
	[Col3] [nvarchar](128) NULL,
	[Col4] [nvarchar](128) NULL,
	[Col5] [nvarchar](128) NULL,
	[Col6] [nvarchar](128) NULL,
	[Col7] [nvarchar](128) NULL,
	[Col8] [nvarchar](128) NULL,
	[Col9] [nvarchar](128) NULL,
	[Col10] [nvarchar](128) NULL,
	[Col11] [nvarchar](128) NULL,
	[Col12] [nvarchar](128) NULL,
	[Col13] [nvarchar](128) NULL,
	[Col14] [nvarchar](128) NULL,
	[Col15] [nvarchar](128) NULL,
	[Col16] [nvarchar](128) NULL
) ON [PRIMARY]

GO

--used to collect fragmentation levels
CREATE TABLE [dbo].[IndexOverview_FragLevels](
	[ServerName] [nvarchar](128) NULL,
	[DBName] [varchar](100) NOT NULL,
	[Table] [sysname] NOT NULL,
	[Index] [sysname] NULL,
	[avg_fragmentation_in_percent] [float] NULL,
	[page_count] [bigint] NULL
) ON [PRIMARY]

GO

--used to collect the most expensive and longest running queries
CREATE TABLE [dbo].[IndexOverview_LongestQueries](
	[ServerName] [nvarchar](128) NULL,
	[DBName] [varchar](100) NOT NULL,
	[QueryName] [nvarchar](max) NULL,
	[ExecutionCount] [bigint] NOT NULL,
	[MaxElapsedTime] [bigint] NOT NULL,
	[AvgElapsedTime] [bigint] NOT NULL,
	[LogCreatedOn] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO

--used to collect missing index
CREATE TABLE [dbo].[IndexOverview_MissingIndex](
	[ServerName] [nvarchar](128) NULL,
	[DBName] [varchar](100) NOT NULL,
	[DatabaseID] [smallint] NOT NULL,
	[Avg_Estimated_Impact] [float] NULL,
	[Last_User_Seek] [datetime] NULL,
	[TableName] [nvarchar](128) NULL,
	[Create_Statement] [nvarchar](4000) NULL
) ON [PRIMARY]

GO


--used to collect unused index
CREATE TABLE [dbo].[IndexOverview_UnusedIndex](
	[ServerName] [nvarchar](128) NULL,
	[DBName] [varchar](100) NOT NULL,
	[ObjectName] [sysname] NOT NULL,
	[IndexName] [sysname] NULL,
	[IndexID] [int] NOT NULL,
	[UserSeek] [bigint] NOT NULL,
	[UserScans] [bigint] NOT NULL,
	[UserLookups] [bigint] NOT NULL,
	[UserUpdates] [bigint] NOT NULL,
	[TableRows] [bigint] NULL,
	[drop statement] [nvarchar](790) NULL
) ON [PRIMARY]
go
